/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9062;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.common.block.Blocks;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.tile_entity.TileEntityMusicBox;

public class BlockMusicBox
extends class_2383
implements class_2343 {
    public static final MapCodec<BlockMusicBox> CODEC = BlockMusicBox.method_54094(BlockMusicBox::new);
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 POWERING = class_2746.method_11825((String)"powering");
    public static final class_2746 HAS_MUSIC = class_2746.method_11825((String)"has_music");
    public static final class_2746 HAS_INSTRUMENT = class_2746.method_11825((String)"has_instrument");

    public BlockMusicBox(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)HAS_MUSIC, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)HAS_INSTRUMENT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)POWERING, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends class_2383> method_53969() {
        return CODEC;
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(context.method_8045().method_49803(context.method_8037())))).method_11657((class_2769)field_11177, (Comparable)context.method_8042());
    }

    public void method_9612(@NotNull class_2680 state, @NotNull class_1937 worldIn, @NotNull class_2338 pos, @NotNull class_2248 blockIn, @NotNull class_2338 fromPos, boolean isMoving) {
        if (!worldIn.field_9236) {
            boolean powered = worldIn.method_49803(pos);
            if (powered && ((Boolean)state.method_11654((class_2769)POWERING)).booleanValue()) {
                return;
            }
            if (powered != (Boolean)state.method_11654((class_2769)POWERED)) {
                worldIn.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
            }
        }
    }

    private void ejectItem(class_1937 world, class_2338 pos, class_2680 state, boolean isMusic, boolean isBreaking) {
        class_2586 blockEntity;
        if (!world.field_9236 && (blockEntity = world.method_8321(pos)) instanceof TileEntityMusicBox) {
            class_1799 itemstack;
            TileEntityMusicBox te = (TileEntityMusicBox)blockEntity;
            if (isMusic) {
                itemstack = te.getSheetStack();
            } else {
                IItemInstrument instrument = te.getInstrument();
                class_1799 class_17992 = itemstack = instrument != null ? new class_1799((class_1935)instrument) : class_1799.field_8037;
            }
            if (!itemstack.method_7960()) {
                class_1542 itemEntity;
                if (!isBreaking) {
                    if (isMusic) {
                        te.removeSheetStack();
                        world.method_8652(pos, (class_2680)state.method_11657((class_2769)HAS_MUSIC, (Comparable)Boolean.FALSE), 3);
                    } else {
                        te.removeInstrument();
                        world.method_8652(pos, (class_2680)state.method_11657((class_2769)HAS_INSTRUMENT, (Comparable)Boolean.FALSE), 3);
                    }
                }
                if (isMusic) {
                    itemEntity = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264() + 1.0, (double)pos.method_10260(), itemstack);
                    itemEntity.method_18800(world.field_9229.method_43058() * 0.2 - 0.1, 0.1, world.field_9229.method_43058() * 0.2 - 0.1);
                } else {
                    class_2350 backFace = ((class_2350)state.method_11654((class_2769)field_11177)).method_10153();
                    int xOffset = backFace.method_10148();
                    int zOffset = backFace.method_10165();
                    itemEntity = new class_1542(world, (double)pos.method_10263() + (double)xOffset * 0.625, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + (double)zOffset * 0.625, itemstack);
                    double speed = world.field_9229.method_43058() * 0.1 + 0.2;
                    itemEntity.method_18800((double)xOffset * speed, 0.1, (double)zOffset * speed);
                }
                itemEntity.method_6988();
                world.method_8649((class_1297)itemEntity);
            }
        }
    }

    public static void insertMusic(class_1936 worldIn, class_2338 pos, class_2680 state, class_1799 sheetStack) {
        class_2586 blockEntity = worldIn.method_8321(pos);
        if (blockEntity instanceof TileEntityMusicBox) {
            ((TileEntityMusicBox)blockEntity).setSheetStack(sheetStack, true);
            worldIn.method_8652(pos, (class_2680)state.method_11657((class_2769)HAS_MUSIC, (Comparable)Boolean.TRUE), 3);
        }
    }

    public static void insertInstrument(class_1936 worldIn, class_2338 pos, class_2680 state, class_1792 instrument) {
        class_2586 blockEntity = worldIn.method_8321(pos);
        if (blockEntity instanceof TileEntityMusicBox) {
            ((TileEntityMusicBox)blockEntity).setInstrument(instrument);
            worldIn.method_8652(pos, (class_2680)state.method_11657((class_2769)HAS_INSTRUMENT, (Comparable)Boolean.TRUE), 3);
        }
        worldIn.method_8396(null, pos, class_3417.field_14541, class_3419.field_15245, 1.0f, worldIn.method_8409().method_43057() * 0.1f + 0.9f);
    }

    @NotNull
    public class_9062 method_55765(@NotNull class_1799 stack, @NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, class_1657 player, @NotNull class_1268 hand, class_3965 hitResult) {
        class_1799 heldItem = player.method_5998(hand);
        if (hitResult.method_17780() == class_2350.field_11036 && ((Boolean)state.method_11654((class_2769)HAS_MUSIC)).booleanValue()) {
            if (heldItem.method_7909() instanceof IItemInstrument && !((Boolean)state.method_11654((class_2769)HAS_INSTRUMENT)).booleanValue()) {
                return class_9062.field_47731;
            }
            this.ejectItem(level, pos, state, true, false);
            return class_9062.field_47728;
        }
        if (hitResult.method_17780() == ((class_2350)state.method_11654((class_2769)field_11177)).method_10153() && ((Boolean)state.method_11654((class_2769)HAS_INSTRUMENT)).booleanValue()) {
            if (heldItem.method_7909() == Items.MUSIC_SHEET && !((Boolean)state.method_11654((class_2769)HAS_MUSIC)).booleanValue()) {
                return class_9062.field_47731;
            }
            level.method_8396(player, pos, class_3417.field_14664, class_3419.field_15245, 1.0f, level.method_8409().method_43057() * 0.1f + 0.9f);
            this.ejectItem(level, pos, state, false, false);
            return class_9062.field_47728;
        }
        return class_9062.field_47731;
    }

    public void method_9536(class_2680 state, @NotNull class_1937 worldIn, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
        if (state.method_26204() != Blocks.MUSIC_BOX || newState.method_26204() != Blocks.MUSIC_BOX) {
            this.ejectItem(worldIn, pos, state, true, true);
            this.ejectItem(worldIn, pos, state, false, true);
            super.method_9536(state, worldIn, pos, newState, isMoving);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{POWERED, HAS_MUSIC, HAS_INSTRUMENT, field_11177, POWERING});
    }

    public boolean method_9506(@NotNull class_2680 state) {
        return true;
    }

    public int method_9603(class_2680 blockState, @NotNull class_1922 blockAccess, @NotNull class_2338 pos, @NotNull class_2350 side) {
        return blockState.method_26195(blockAccess, pos, side);
    }

    public int method_9524(class_2680 blockState, @NotNull class_1922 blockAccess, @NotNull class_2338 pos, @NotNull class_2350 side) {
        if (!((Boolean)blockState.method_11654((class_2769)POWERING)).booleanValue()) {
            return 0;
        }
        return ((class_2350)blockState.method_11654((class_2769)field_11177)).method_10160() == side ? 15 : 0;
    }

    @Nullable
    public class_2586 method_10123(@NotNull class_2338 blockPos, @NotNull class_2680 blockState) {
        return new TileEntityMusicBox(blockPos, blockState);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 level, @NotNull class_2680 blockState, @NotNull class_2591<T> blockEntityType) {
        return (level1, blockPos, blockState1, t) -> {
            if (t instanceof TileEntityMusicBox) {
                TileEntityMusicBox.tick(level1, blockPos, blockState1, (TileEntityMusicBox)t);
            }
        };
    }
}

